/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class QMLine {
    private String text;
    private Point loc;
    private Dimension dim;
    private Font font;
    private FontMetrics fm;

    public QMLine(String string, Point point, Font font, FontMetrics fontMetrics) {
        this.text = string;
        this.loc = point;
        this.font = font;
        this.fm = fontMetrics;
        this.dim = new Dimension(fontMetrics.stringWidth(string), font.getSize());
    }

    public boolean isPartOf(Point point) {
        return point.x >= this.loc.x && point.y >= this.loc.y && point.x < this.loc.x + this.dim.width && point.y < this.loc.y + this.dim.height;
    }

    public boolean isPartOf(Point point, QMLine qMLine) {
        return this.isPartOf(point) || point.x >= this.loc.x && point.y >= qMLine.loc.y + qMLine.dim.height && point.x < this.loc.x + Math.min(this.dim.width, qMLine.dim.width) && point.y < this.loc.y;
    }

    public void paint(Graphics graphics, Color color) {
        graphics.setFont(this.font);
        graphics.setColor(color);
        graphics.drawString(this.text, this.loc.x, this.loc.y + this.fm.getMaxAscent());
    }

    public static Point addLines(Vector vector, String string, Point point, int n, Font font, FontMetrics fontMetrics) {
        point = new Point(point.x, point.y);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = false;
        while (n2 < string.length() && string.charAt(n2) != '\n' && string.charAt(n2) != ' ') {
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        while (n2 < string.length()) {
            bl = true;
            while (bl && n2 < string.length() && string.charAt(n2) != '\n') {
                ++n2;
                stringBuffer = new StringBuffer();
                while (n2 < string.length() && string.charAt(n2) != '\n' && string.charAt(n2) != ' ') {
                    stringBuffer.append(string.charAt(n2));
                    ++n2;
                }
                if (fontMetrics.stringWidth(stringBuffer2.toString() + " " + stringBuffer.toString()) < n) {
                    stringBuffer2.append(" " + stringBuffer.toString());
                    continue;
                }
                bl = false;
            }
            vector.addElement(new QMLine(stringBuffer2.toString(), point, font, fontMetrics));
            point = new Point(point.x, point.y + font.getSize() + 5);
            if (n2 < string.length() && bl && string.charAt(n2) == '\n') {
                ++n2;
                stringBuffer = new StringBuffer();
                while (n2 < string.length() && string.charAt(n2) != '\n' && string.charAt(n2) != ' ') {
                    stringBuffer.append(string.charAt(n2));
                    ++n2;
                }
                if (n2 >= string.length()) {
                    bl = false;
                }
            }
            stringBuffer2 = new StringBuffer(stringBuffer.toString());
        }
        if (!bl) {
            vector.addElement(new QMLine(stringBuffer2.toString(), point, font, fontMetrics));
            point = new Point(point.x, point.y + font.getSize() + 5);
        }
        if (0 > string.length()) {
            point = new Point(point.x, point.y - 5);
        }
        return point;
    }
}

