/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

public class QMQuestion {
    private Image picture;
    private Vector textQuestion = new Vector(10, 10);
    private Vector textSolution1 = new Vector(10, 10);
    private Vector textSolution2 = new Vector(10, 10);
    private Vector answers = new Vector(10, 10);
    private int correct = 0;
    private int selected = -1;
    private int pointed = -1;
    public QMData qmd;

    public QMQuestion(QMData qMData, Image image, String string, Vector vector, String string2, int n) throws Exception {
        this.qmd = qMData;
        this.picture = image;
        this.correct = n;
        Point point = qMData.startLoc;
        point = QMLine.addLines(this.textQuestion, string, point, qMData.maximumWidth, QuizMaster.fonts[0], QuizMaster.fms[0]);
        point.y += 5;
        int n2 = (qMData.maximumWidth - qMData.numberOfColumns * 10 + 10) / qMData.numberOfColumns;
        if (n2 < 26) {
            throw new Exception("To little TextMaxWidth or to many columns.");
        }
        Point[] pointArray = new Point[qMData.numberOfColumns];
        int n3 = 0;
        while (n3 < pointArray.length) {
            pointArray[n3] = new Point(point.x + n3 * (10 + n2), point.y);
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < vector.size()) {
            this.answers.addElement(new QMAnswer(this, (String)vector.elementAt(n5), pointArray[n4], n2));
            ++n4;
            n4 %= qMData.numberOfColumns;
            ++n5;
        }
        int n6 = 0;
        while (n6 < pointArray.length) {
            point.y = Math.max(point.y, pointArray[n6].y);
            ++n6;
        }
        QMLine.addLines(this.textSolution1, QuizMaster.strings[0] + string2, point, qMData.maximumWidth, QuizMaster.fonts[2], QuizMaster.fms[2]);
        QMLine.addLines(this.textSolution2, QuizMaster.strings[1] + string2, point, qMData.maximumWidth, QuizMaster.fonts[2], QuizMaster.fms[2]);
    }

    public void reset() {
        this.selected = -1;
    }

    public void paint(Graphics graphics) {
        block7: {
            if (this.picture != null) {
                graphics.drawImage(this.picture, this.qmd.startImage.x, this.qmd.startImage.y, this.qmd.qm);
            }
            int n = 0;
            while (n < this.textQuestion.size()) {
                ((QMLine)this.textQuestion.elementAt(n)).paint(graphics, QuizMaster.colors[1]);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.answers.size()) {
                ((QMAnswer)this.answers.elementAt(n2)).paint(graphics, this.selected >= 0 ? (this.correct == n2 ? 2 : (this.selected == n2 ? 1 : 0)) : (this.pointed == n2 ? 1 : 0));
                ++n2;
            }
            if (this.selected < 0) break block7;
            if (this.selected == this.correct) {
                int n3 = 0;
                while (n3 < this.textSolution1.size()) {
                    ((QMLine)this.textSolution1.elementAt(n3)).paint(graphics, QuizMaster.colors[5]);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < this.textSolution2.size()) {
                    ((QMLine)this.textSolution2.elementAt(n4)).paint(graphics, QuizMaster.colors[6]);
                    ++n4;
                }
            }
        }
    }

    public boolean mouseMoved(Point point) {
        if (this.selected >= 0) {
            return false;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.answers.size()) {
            if (((QMAnswer)this.answers.elementAt(n2)).isPartOf(point)) {
                n = n2;
            }
            ++n2;
        }
        if (n != this.pointed) {
            this.pointed = n;
            return true;
        }
        return false;
    }

    public boolean mousePressed(Point point) {
        if (this.selected >= 0) {
            return false;
        }
        int n = 0;
        while (n < this.answers.size()) {
            if (((QMAnswer)this.answers.elementAt(n)).isPartOf(point)) {
                this.selected = n;
                this.pointed = -1;
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getScore() {
        return this.selected == this.correct ? 1 : 0;
    }
}

