/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class QuizMaster
extends Applet
implements MouseListener,
MouseMotionListener {
    public boolean registered = true;
    private Image gbuffer;
    private Graphics gbuf;
    private QMData qmd;
    public static Color[] colors = new Color[10];
    public static Font[] fonts = new Font[4];
    public static FontMetrics[] fms = new FontMetrics[4];
    public static String[] strings = new String[2];
    public Dimension dim;
    public String errorString;

    public void init() {
        System.out.println("\nQuizMaster Version 1.1.0");
        System.out.println("************************\n");
        System.out.println(" Registered applet\n");
        this.dim = this.getSize();
        this.setLayout(null);
        QuizMaster.strings[0] = this.getParameter("TagCorrect");
        if (strings[0] == null) {
            QuizMaster.strings[0] = "";
        }
        strings[0] = strings[0] + " ";
        QuizMaster.strings[1] = this.getParameter("TagWrong");
        if (strings[1] == null) {
            QuizMaster.strings[1] = "";
        }
        strings[1] = strings[1] + " ";
        try {
            QuizMaster.fonts[0] = new Font(this.getParameter("QuestionFontStyle"), 0, Integer.parseInt(this.getParameter("QuestionFontSize")));
            QuizMaster.fonts[1] = new Font(this.getParameter("AnswerFontStyle"), 0, Integer.parseInt(this.getParameter("AnswerFontSize")));
            QuizMaster.fonts[2] = new Font(this.getParameter("ExplanationFontStyle"), 0, Integer.parseInt(this.getParameter("ExplanationFontSize")));
            QuizMaster.fonts[3] = new Font(this.getParameter("ScoreFontStyle"), 0, Integer.parseInt(this.getParameter("ScoreFontSize")));
        }
        catch (Exception exception) {
            this.errorString = "One of the FontStyle or FontSize parameters is wrong";
            System.out.println(this.errorString + "\n" + exception);
        }
        try {
            QuizMaster.colors[0] = new Color(Integer.parseInt(this.getParameter("BackgroundColor"), 16));
            this.setBackground(colors[0]);
            QuizMaster.colors[1] = new Color(Integer.parseInt(this.getParameter("QuestionColor"), 16));
            QuizMaster.colors[2] = new Color(Integer.parseInt(this.getParameter("AnswerColorOut"), 16));
            QuizMaster.colors[3] = new Color(Integer.parseInt(this.getParameter("AnswerColorOver"), 16));
            QuizMaster.colors[4] = new Color(Integer.parseInt(this.getParameter("AnswerColorSolution"), 16));
            QuizMaster.colors[5] = new Color(Integer.parseInt(this.getParameter("ExplanationColorCorrect"), 16));
            QuizMaster.colors[6] = new Color(Integer.parseInt(this.getParameter("ExplanationColorWrong"), 16));
            QuizMaster.colors[7] = new Color(Integer.parseInt(this.getParameter("ScoreColor"), 16));
            QuizMaster.colors[8] = new Color(Integer.parseInt(this.getParameter("ButtonColorOut"), 16));
            QuizMaster.colors[9] = new Color(Integer.parseInt(this.getParameter("ButtonColorOver"), 16));
        }
        catch (Exception exception) {
            this.errorString = "One of the Color parameters is wrong";
            System.out.println(this.errorString + "\n" + exception);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.errorString != null) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.dim.width, this.dim.height);
            graphics.setColor(Color.black);
            graphics.setFont(new Font("Arial", 0, 16));
            if (this.errorString.indexOf("\n") > 0) {
                graphics.drawString(this.errorString.substring(0, this.errorString.indexOf("\n")), 10, 20);
                graphics.drawString(this.errorString.substring(this.errorString.indexOf("\n") + 1, this.errorString.length()), 10, 50);
            } else {
                graphics.drawString(this.errorString, 10, 20);
            }
        } else {
            if (this.gbuffer == null) {
                try {
                    this.gbuffer = this.createImage(this.dim.width, this.dim.height);
                    this.gbuf = this.gbuffer.getGraphics();
                }
                catch (Exception exception) {
                    this.gbuf = graphics;
                    this.gbuffer = null;
                }
                int n = 0;
                while (n < fonts.length) {
                    this.gbuf.setFont(fonts[n]);
                    QuizMaster.fms[n] = this.gbuf.getFontMetrics();
                    ++n;
                }
                if (this.qmd == null) {
                    this.qmd = new QMData(this);
                }
            }
            this.qmd.paint(this.gbuf);
            if (this.gbuffer != null) {
                graphics.drawImage(this.gbuffer, 0, 0, this.dim.width, this.dim.height, this);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.qmd != null && this.qmd.mousePressed(mouseEvent.getPoint())) {
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.qmd != null && this.qmd.mouseMoved(new Point(-1, -1))) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.qmd != null && this.qmd.mouseMoved(mouseEvent.getPoint())) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.qmd != null && this.qmd.mouseMoved(mouseEvent.getPoint())) {
            this.repaint();
        }
    }
}

